<?php

define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'twentyten_header_image_height', 58 ) );
define( 'HEADER_IMAGE_WIDTH', apply_filters( 'twentyten_header_image_width', 1017 ) );

add_image_size( 'thumb1017x710', 1017, 710, true );
add_image_size( 'thumb42x32', 42, 32, true );

function galleria_script(){ ?>
	    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.4/jquery.min.js"></script>
        <script src="<?php echo get_bloginfo("stylesheet_directory")."/js/galleria.js";?>"></script>
        
<?php }
add_action('wp_head','galleria_script');


function my_init_method() {
    wp_deregister_script( 'jquery' );
    wp_register_script( 'jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js');
}    
 
//add_action('init', 'my_init_method');

//
function load_slider(){
	//Get Description
	$post_id=2;
	$post = get_post($post_id);
	$title = $post->post_title;
	$content = $post->post_content;
	$content2strip = $content;
	$address = get_post_meta($post_id, 'Address', true);
	$city = get_post_meta($post_id, 'City', true);
	$state = get_post_meta($post_id, 'State', true);
	$long_title = $title." - ".$address.", ".$city.", ".$state;
	$price = get_post_meta($post_id, 'Price', true);
	//AGENTS
	$user_role="contributor";
	$authors = getUsersByRole( $user_role );
	$authors_count=count($authors);
	?>
	
    <div class='wds_menu'>
		<a onclick="wds_show('wds_description');" style="cursor:pointer;">Description</a> |
        <a onclick="wds_show('map_canvas');" style="cursor:pointer;">Map</a>
        <?php if($authors_count>0){?>
        	| <a onclick="wds_show('wds_agent');" style="cursor:pointer;">Contact Agent</a>
        <?php } ?>
    </div>
    
	<?php
	
	
	
	if ( $images = get_children( array( 'post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image', 'orderby' => 'menu_order', 'order' => 'ASC', 'numberposts' => -1 ) ) ) {
		if ($images) {
			$keys = array_keys($images);
			$count = count($keys);
			for ($i = 0; $i < $count; $i++) {
				$img=$keys[$i];
				$imgurl = wp_get_attachment_image_src( $img, "thumb42x32" );
				$TargetSrc = wp_get_attachment_url($img);
				$TargetSrc=str_replace(".jpg","-1017x710.jpg",$TargetSrc);
				$TargetSrc=str_replace(".png","-1017x710.png",$TargetSrc);
				$TargetSrc=str_replace(".gif","-1017x710.gif",$TargetSrc);
				$images2=$images2.'<a rel="galleryid'.$post_id.'" class="thickbox" title="'.$thetitle.'" href="' . $TargetSrc . '"><img width="'.$imgurl[1].'px" height="'.$imgurl[2].'px" class="thumbnail" src="' . $imgurl[0] . '" /></a>';
			}
			echo "<div id='wds_slider' class='wds_slider' style='display:none;'>";
				
				echo "<div id='wds_box' style='display:none;'>";
					echo "<div id='wds_description' style='display:none;'>";
						echo "<div class='wds_title'>";
							echo $title."<br>";
							echo $address."<br>";
							echo $city.", ".$state."<br>";
							echo $price;
						echo "</div>";
						echo "<div id='wds_content'>";
							echo $content;
						echo "</div>";
					echo "</div>";
					//AGENTS
					if($authors_count>0){
						echo "<div id='wds_agent' style='display:none;'>";
							foreach ( $authors as $item ) {
								$author = get_userdata($item);
								
								echo "<div class='wds_agent_top'>";
									if($authors_count<3){
										echo "<div class='wds_agent_pic'>";
											$img = '<img src="' . get_option('siteurl') . '/wp-content/uploads/userphoto/' . $author->userphoto_image_file . '">';
											echo $img;
										echo "</div>";
									}
									echo "<div class='wds_agent_connect'>";
										if($author->facebook)
											echo '<a target="_blank" href="'.$author->facebook.'"><img alt="Facebook" src="'.get_bloginfo('stylesheet_directory').'/images/facebook.png"></a>';
										if($author->twitter)
											echo '<a target="_blank" href="'.$author->twitter.'"><img alt="Twitter" src="'.get_bloginfo('stylesheet_directory').'/images/twitter.png"></a>';
										if($author->linkedin)
											echo '<a target="_blank" href="'.$author->linkedin.'"><img alt="LinkedIn" src="'.get_bloginfo('stylesheet_directory').'/images/linkedin.png"></a>';
										if($author->youtube)
											echo '<a target="_blank" href="'.$author->youtube.'"><img alt="YouTube" src="'.get_bloginfo('stylesheet_directory').'/images/youtube.png"></a>';
									echo "</div>";
									
									echo "<div class='wds_agent_name'>";
										echo "<b>".$author->first_name."</b><br>";
										echo "<b>".$author->last_name."</b>";
										echo "<div class='wds_company'>" . $author->company . "</div>";
									echo "</div>";
								echo "</div>";
								echo "<div class='wds_agent_contacts'>";
									$emails=$author->user_email.",".$emails;
									echo "<a href='mailto:".$author->user_email."'>".$author->user_email."<br>";
									if($author->user_url)
										echo "<a target='_blank' href='".$author->user_url."'>".str_replace("http://","",$author->user_url)."</a><br>";
									if($author->direct)
										echo "Direct: ".$author->direct."<br>";
									if($author->office)
										echo "Office: ".$author->office."<br>";
									if($author->dre)
										echo "BRE #".$author->dre."<br>";
								echo "</div>";
								
								echo "<div class='wds_agent_spacer'></div>";
							}
							echo "<div class='wds_agent_email'><a href='mailto:".$emails."?subject=".$title."'>Schedule a Showing</a></div>";
						echo "</div>";
					}
					//CONNECT
					/*echo "<div id='wds_connect' style='display:none;'>";
						if($facebook)
							echo "<a target='_blank' href='".$facebook."'><img src='".get_bloginfo('stylesheet_directory')."/images/facebook-icon.png'></a>";
						if($twitter)
							echo "<a target='_blank' href='".$twitter."'><img src='".get_bloginfo('stylesheet_directory')."/images/twitter-icon.png'></a>";
						?>
                        <div class="entry-utility">
                        <div class="social-share">
                        <ul>
                        <li class="facebook-link">
                            <script src="http://connect.facebook.net/en_US/all.js#xfbml=1"></script>
                            <fb:like layout="button_count" width="90" href="<?php echo get_option('siteurl');?>" colorscheme="none"></fb:like>
                        </li>
                        <li class="twitter-link">
                            <script src="http://platform.twitter.com/widgets.js" type="text/javascript"></script>
                            <a href="http://twitter.com/share" class="twitter-share-button"
                                data-url="<?php echo get_option('siteurl'); ?>"
                                data-via="<?php echo $title; ?>"
                                data-text="<?php echo $long_title; ?>"
                                data-count="horizontal">Tweet</a>
                        </li>
                        <li>
                            <a href="http://www.google.com/buzz/post"
                              class="google-buzz-button" title="Google Buzz"
                              data-message="<?php echo $long_title; ?> - <?php echo $content2strip; ?>"
                              data-url="<?php echo get_option('siteurl'); ?>"
                              data-imageurl="<?php echo $imgurl[0];?>"
                              data-locale="en"
                              data-button-style="small-count"></a>
                            <script type="text/javascript" src="http://www.google.com/buzz/api/button.js"></script>
                        </li>
                        <li>
                            <script type="text/javascript">
                            (function() {
                            var s = document.createElement('SCRIPT'), s1 = document.getElementsByTagName('SCRIPT')[0];
                            s.type = 'text/javascript';
                            s.async = true;
                            s.src = 'http://widgets.digg.com/buttons.js';
                            s1.parentNode.insertBefore(s, s1);
                            })();
                            </script>
                            <a class="DiggThisButton DiggCompact"></a>
                        </li>
                        </ul>
                        </div>
                        </div>
                        <?php
						
					echo "</div>";*/
					echo "<div class='wds_close' onclick='wds_hide();'><a>X</a></div>";
					
				
				echo "</div>";
				
			?>
                <div id="galleria">
                    <?php echo $images2;?>
                </div>
            </div>
			
            <script>
				
				
				function wds_show(div){
					document.getElementById('wds_box').style.display='';
					if(div=="wds_agent"){
						document.getElementById('wds_description').style.display='none';
						document.getElementById('map_canvas').style.height='0px';
						document.getElementById('wds_slider').style.height='770px';
					}else if(div=="map_canvas"){
						initialize();
						document.getElementById('wds_box').style.display='none';
						document.getElementById('map_canvas').style.height='770px';
						document.getElementById('wds_slider').style.height='0px';
					}else{
						<?php if($authors_count>0){?>
						document.getElementById('wds_agent').style.display='none';
						<?php } ?>
						document.getElementById('map_canvas').style.height='0px';
						document.getElementById('wds_slider').style.height='770px';
					}
					document.getElementById(div).style.display='';
				}
				function wds_hide(){
					document.getElementById('wds_box').style.display='none';
				}
				
				
			</script>
			
			<?php //MAP
			$width="1017";
			$height="710";
			$address=$address.", ".$city.", ".$state;
			wds_build_map($address,17,'ROADMAP',$width,$height);
			?>
            <div id="map_canvas" style="width:<?php echo $width;?>px;">
            </div>
			<?php
		}
	}
	
}


//MAP
function wds_build_map($address,$zoom,$map,$width,$height){?>
	<meta name="viewport" content="initial-scale=1.0, width=device-widt" />
	<style type="text/css">
	  #map_canvas { width:100%;height: 100% }
	</style>
	<script type="text/javascript"
		src="http://maps.google.com/maps/api/js?sensor=true">
	</script>
	<script type="text/javascript">
	  	function initialize() {
			geocoder = new google.maps.Geocoder();
			var address = '<?php echo $address;?>';
			geocoder.geocode( { 'address': address}, function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					place=results[0].geometry.location;
					//alert(place);
					var myOptions = {
					  zoom: <?php echo $zoom;?>,
					  center: place,
					  mapTypeId: google.maps.MapTypeId.<?php echo $map;?>,
					  streetViewControl:true
					}
					map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
					
					panorama = map.getStreetView();
					panorama.setPosition(place);
					panorama.setPov({
						heading: 265,
						zoom:1,
						pitch:0
					});
					
					map.setCenter(place);
					var marker = new google.maps.Marker({
						map: map, 
						position: place
					});
					
				}
			});
		}
	  
	  function toggleStreetView() {
		  var toggle = panorama.getVisible();
		  if (toggle == false) {
			panorama.setVisible(true);
		  } else {
			panorama.setVisible(false);
		  }
		}
	  
	  
	  function codeAddress() {
		var address = '<?php echo $address;?>';
		geocoder.geocode( { 'address': address}, function(results, status) {
		  if (status == google.maps.GeocoderStatus.OK) {
			map.setCenter(results[0].geometry.location);
			
			var marker = new google.maps.Marker({
				map: map, 
				position: results[0].geometry.location
			});
		  } else {
			alert("Geocode was not successful for the following reason: " + status);
		  }
		});
	  }
	</script>
   <?php
}


//Get users by role
function getUsersByRole( $role ) {
	if ( class_exists( 'WP_User_Search' ) ) {
		$wp_user_search = new WP_User_Search( '', '', $role );
		$userIDs = $wp_user_search->get_results();
	} else {
		global $wpdb;
		$userIDs = $wpdb->get_col('
			SELECT ID
			FROM '.$wpdb->users.' INNER JOIN '.$wpdb->usermeta.'
			ON '.$wpdb->users.'.ID = '.$wpdb->usermeta.'.user_id
			WHERE '.$wpdb->usermeta.'.meta_key = \''.$wpdb->prefix.'capabilities\'
			AND '.$wpdb->usermeta.'.meta_value LIKE \'%"'.$role.'"%\'
		');
	}
	return $userIDs;
}




//USER PHOTOS
include "i/user-photo.php";
//EXTRA USER META FIELDS
add_action( 'show_user_profile', 'my_show_extra_profile_fields' ,1 );
add_action( 'edit_user_profile', 'my_show_extra_profile_fields' ,1 );

function my_show_extra_profile_fields( $user ) { ?>

	<h3>Extra Profile Information</h3>

	<table class="form-table">

		<tr>
			<th><label for="twitter">Company</label></th>
			<td>
				<input type="text" name="company" id="company" value="<?php echo esc_attr( get_the_author_meta( 'company', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">Direct Phone</label></th>
			<td>
				<input type="text" name="direct" id="direct" value="<?php echo esc_attr( get_the_author_meta( 'direct', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">Office Phone</label></th>
			<td>
				<input type="text" name="office" id="office" value="<?php echo esc_attr( get_the_author_meta( 'office', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">DRE #</label></th>
			<td>
				<input type="text" name="dre" id="dre" value="<?php echo esc_attr( get_the_author_meta( 'dre', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">Facebook URL</label></th>
			<td>
				<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">Twitter URL</label></th>
			<td>
				<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">LinkedIn URL</label></th>
			<td>
				<input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>
        
        <tr>
			<th><label for="twitter">YouTube URL</label></th>
			<td>
				<input type="text" name="youtube" id="youtube" value="<?php echo esc_attr( get_the_author_meta( 'youtube', $user->ID ) ); ?>" class="regular-text" /><br />
			</td>
		</tr>

	</table>
<?php }


//SAVE CUSTOM USER META
add_action( 'personal_options_update', 'my_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'my_save_extra_profile_fields' );

function my_save_extra_profile_fields( $user_id ) {
	if ( !current_user_can( 'edit_user', $user_id ) )
		return false;
	update_usermeta( $user_id, 'company', $_POST['company'] );
	update_usermeta( $user_id, 'direct', $_POST['direct'] );
	update_usermeta( $user_id, 'office', $_POST['office'] );
	update_usermeta( $user_id, 'dre', $_POST['dre'] );
	update_usermeta( $user_id, 'facebook', $_POST['facebook'] );
	update_usermeta( $user_id, 'twitter', $_POST['twitter'] );
	update_usermeta( $user_id, 'linkedin', $_POST['linkedin'] );
	update_usermeta( $user_id, 'youtube', $_POST['youtube'] );
}




?>